//
//  LoginAndSecurityViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 13.02.23.
//

import JNGradientLabel
import UIKit

class LoginAndSecurityViewController : UIViewController, UIViewControllerTransitioningDelegate {
    
    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    

    @IBOutlet weak var securityProceduresLabel: UILabel!
    
    @IBOutlet var trustDeviceLabel: UILabel!
    
    @IBOutlet var storeSettingsButton: UIButton!
    
    @IBOutlet var logOutLabel: UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        self.navigationItem.backBarButtonItem?.tintColor = UIColor.white
        
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        
        // style labels
        securityProceduresLabel.font = Fonts.mediumFontWithSize(size: 18)
        trustDeviceLabel.font = Fonts.mediumFontWithSize(size: 18)
        logOutLabel.font = Fonts.mediumFontWithSize(size: 18)
        
        // style store settings button
        storeSettingsButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 18)
        Utilities.styleFilledButtonAuthScreenGreenEdged(storeSettingsButton)
        
        // Button style...
        // https://www.appsdeveloperblog.com/clickable-uilabel-in-swift-programmatically/
        // Enable User Interaction
        securityProceduresLabel.isUserInteractionEnabled = true
        // Create and add the Gesture Recognizer
        let guestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(labelClicked(_:)))
        securityProceduresLabel.addGestureRecognizer(guestureRecognizer)
        
        logOutLabel.isUserInteractionEnabled = true
        // Create and add the Gesture Recognizer
        let guestureRecognizer_logOutLabel = UITapGestureRecognizer(target: self, action: #selector(labelClicked_logOutLabel(_:)))
        logOutLabel.addGestureRecognizer(guestureRecognizer_logOutLabel)
        
    }

    
    // used with tabBarController.swift file
 
    @IBAction func backButton(_ sender: Any) {
    let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        tabBarController.modalPresentationStyle = .fullScreen
        tabBarController.modalTransitionStyle = .coverVertical
        

        //tabBarController.viewControllers?[2]
        present(tabBarController, animated: true)
        
        //self.tabBarController?.selectedIndex = 2
        
        // https://www.youtube.com/watch?v=43LpNQtUvV4
        let indexData: [String: Int] = ["index" : 2]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
    }
    
    @IBAction func storeSettingsButton(_ sender: Any) {
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
        
        let indexData: [String: Int] = ["index" : 2]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
    }

    @objc func labelClicked_logOutLabel(_ sender: Any) {
        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)
            
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left
        
        let message = "Sind Sie sicher, dass Sie sich ausloggen wollen?"
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])
        
        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")

        refreshAlert.addAction(UIAlertAction(title: "Eingeloggt bleiben", style: .cancel, handler: { (action: UIAlertAction!) in

            
        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Eingeloggt bleiben" }) {
            continueAction.setValue(UIColor(red: 49.0/255.0, green: 84.0/255.0, blue: 143.0/255.0, alpha: 1.0), forKey: "titleTextColor")
        }
         
        refreshAlert.addAction(UIAlertAction(title: "Ausloggen", style: .default, handler: { (action: UIAlertAction!) in
            
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
            
            let layout = UICollectionViewFlowLayout()
            self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
            
            
            
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
        }))
        
        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Ausloggen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }
         
        present(refreshAlert, animated: true, completion: nil)
    }
    
    
    @objc func labelClicked(_ sender: Any) {
       
        

        // Fallback...
        if #available(iOS 15.0, *) {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
            let viewController = storyboard.instantiateViewController(withIdentifier: "SecurityProceduresVC")
            
            if let presentationController = viewController.presentationController as? UISheetPresentationController {

                
                presentationController.detents = [.medium()] /// change to [.medium(), .large()] for a half *and* full screen sheet
            }
            self.present(viewController, animated: true)
            
        } else {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let viewController = storyboard.instantiateViewController(withIdentifier: "SecurityProceduresVC")
            viewController.modalPresentationStyle = .custom
            viewController.transitioningDelegate = self
            self.present(viewController, animated: true, completion: nil)
        }
        

    }
    
}
